---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - Feedback Loop
---

# Cycle (feedback loop) (pattern)

> Closed path that reinforces stability or oscillation depending on gain and phase.

---

## Definition

- Closed loop with feedback
- Self-reinforcing or self-regulating
- Phase and gain determine behavior
- Stability depends on margins

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Loop closure | Feedback path | `Monitor`, `Loop` |
| Phase lock | Cycle sync | `Check`, `Phase` |
| Gain control | Level adjust | `Tune`, `Gain` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Loop closure | Coming back | "Returns home" |
| Phase lock | Natural rhythm | "In sync" |
| Gain control | Response level | "Right amount" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Feedback path | Coming back | How cycles close |
| Cycle sync | Natural rhythm | How timing works |
| Level adjust | Response level | How balance forms |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Resonator | Natural cycle |
| Networks | Echo loop | Message cycle |
| Cognition | Memory loop | Thought cycle |
| Systems | Process cycle | Action loop |

---

## Scale Effects

How Cycle pattern manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Loop quantum | Wave cycle |
| λV | Gate cycle | State loop |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase binding | Memory cycle |
| ∇S | Loop clarity | Clear pattern |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Loop limit | Light cycle |
| λV | Field cycle | Space loop |

Note: At extreme scales, cycle behavior faces fundamental limits (e.g., quantum cycles at ε, causal loops at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: gain threshold met
- π: phase geometry stable
- ψA: cycle coherent
- λV: coupling controlled

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Loop definition | Cycle clarity |
| Human | λV | Gate timing | Flow rhythm |
| Cosmic | ψA | Phase lock | Loop binding |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Loop break | Phase slip | Lost pattern |
| Human | Oscillation | Unstable cycle | Lost rhythm |
| Cosmic | Limit breach | Causal break | Lost binding |

---

## Diagnostic Checklist

Technical tests:
- [ ] Phase margin good
- [ ] Gain window stable
- [ ] Coupling controlled
- [ ] Loop integrity held

Humane tests:
- [ ] Cycle feels natural
- [ ] Response balanced
- [ ] Flow controlled
- [ ] Pattern complete

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical feedback nor experiential cycles alone captures its full meaning.

---

## See Also

- [[Path (chain) (pattern)]]
- [[Multi-path (redundant) (pattern)]]
- [[Cascade (pattern)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented